package polymorphicTypes

import scala.language.higherKinds

object ChurcEncodingExample2 {
  
  // A better existential encoding, parametric on f.
  // This requires type-level parameters of the kind of f, namely *=>*
  // The "higherKinds" import line above enables this advanced feature.
  
  
  // exists a. f(a) ~= forall b. (forall a. f(a) -> b) -> b
  
  trait Helper[B,F[_]] {
    def elim[A](f: F[A]): B 
  }
  trait Exists[F[_]] {
    def elim[B](f: Helper[B,F]): B
  }
  
  // A possible f
  trait G[A] {
    def elim: (A, A=>Int)  // using the built-in Scala product for simplicity
  }
  
  // In our specific example, G(a)=(a * a->Int), hence 
  // exists a. Gf(a) ~= Int
  object ExIso1 {
    def iso(e: Exists[G]): Int = {
      object H extends Helper[Int,G] {
        override def elim[A](f: G[A]): Int = f.elim._2(f.elim._1)
      }
      e.elim[Int](H)
    }
    def osi(i: Int): Exists[G] = new Exists[G] {
      object Fint extends G[Int] {
        override def elim: (Int, Int=>Int) = (i, j => j)
      }
      override def elim[B](f: Helper[B,G]): B = f.elim[Int](Fint)
    }
  }
}